/*=============================================================================}
{ This demo shows how to add text in RichView at run-time.                     }
{ See comments in TForm1::FormCreate                                           }
{=============================================================================*/
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Clear deletes all items of RichView.
  // There are no items at the beginning, so this call of Clear() is
  // just for the demonstration.
  RichView1->Clear();

  // Adding the first paragraph.
  // This paragraph has the 1st style (centered by default; you can view/modify
  // it in RVStyle1->ParaStyles property).
  // This paragraph consists of one item of the 1st text style
  RichView1->AddNLWTag("Adding Text", 1, 1, 0);

  // Adding the second paragraph.
  // This paragraph has the 0-th style (style is defined by first item in paragraph).
  RichView1->AddNLWTag("This demo shows how to add text in ", 0, 0, 0);
  // Continuing the second paragraph.
  // Note: -1 is passed as an index of paragraph style.
  // This means that this item will be added to the last paragraph.
  RichView1->AddNLWTag("RichView", 3, -1, 0);
  // Continuing second paragraph...
  RichView1->AddNLWTag(". There are two paragraphs in this document - "
	"the first one with centered alignment, and the second one - "
	"with left alignment. The first paragraph consists of one text item, "
	"and the second paragraph consists of three items. "
	"Each item is added with one call of AddNLWTag method.", 0, -1, 0);
  // But text will not be displayed yet. You need to call Format() method after adding
  // all content to RichView:
  RichView1->Format();
}
//---------------------------------------------------------------------------